<?php

namespace App\Http\Controllers;

use App\Models\Page;
use Illuminate\Http\Request;
use Inertia\Inertia;

class PageController extends Controller
{
    /**
     * Display the specified page.
     *
     * @param  \App\Models\Page  $page
     * @return \Inertia\Response
     */
    public function show(Page $page)
    {
        // Check if the page is active
        if (!$page->is_active) {
            abort(404);
        }

        return Inertia::render('Page', [
            'page' => [
                'title' => $page->title,
                'content' => $page->content,
                'meta_description' => $page->meta_description,
                'updated_at' => $page->updated_at->toFormattedDateString(),
            ]
        ]);
    }
}
