<?php

namespace Database\Seeders;

use App\Models\Page;
use Illuminate\Database\Seeder;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Privacy Policy page
        Page::create([
            'title' => 'Privacy Policy',
            'slug' => 'privacy-policy',
            'content' => '<h2>Privacy Policy</h2>
<p>Last updated: ' . now()->format('F d, Y') . '</p>

<p>This Privacy Policy describes how we collect, use, and disclose your information when you use our service.</p>

<h3>Information Collection and Use</h3>
<p>We collect several different types of information for various purposes to provide and improve our service to you.</p>

<h3>Types of Data Collected</h3>
<h4>Personal Data</h4>
<p>While using our service, we may ask you to provide us with certain personally identifiable information that can be used to contact or identify you. This may include, but is not limited to:</p>
<ul>
    <li>Email address</li>
    <li>First name and last name</li>
    <li>Phone number</li>
    <li>Address, State, Province, ZIP/Postal code, City</li>
    <li>Cookies and Usage Data</li>
</ul>

<h3>Use of Data</h3>
<p>We use the collected data for various purposes:</p>
<ul>
    <li>To provide and maintain our service</li>
    <li>To notify you about changes to our service</li>
    <li>To provide customer support</li>
    <li>To gather analysis or valuable information so that we can improve our service</li>
    <li>To monitor the usage of our service</li>
    <li>To detect, prevent and address technical issues</li>
</ul>

<h3>Transfer of Data</h3>
<p>Your information, including Personal Data, may be transferred to — and maintained on — computers located outside of your state, province, country or other governmental jurisdiction where the data protection laws may differ from those of your jurisdiction.</p>

<h3>Disclosure of Data</h3>
<p>We may disclose your Personal Data in the good faith belief that such action is necessary to:</p>
<ul>
    <li>To comply with a legal obligation</li>
    <li>To protect and defend the rights or property of our company</li>
    <li>To prevent or investigate possible wrongdoing in connection with the service</li>
    <li>To protect the personal safety of users of the service or the public</li>
    <li>To protect against legal liability</li>
</ul>

<h3>Security of Data</h3>
<p>The security of your data is important to us but remember that no method of transmission over the Internet or method of electronic storage is 100% secure.</p>

<h3>Changes to This Privacy Policy</h3>
<p>We may update our Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page.</p>',
            'meta_description' => 'Our Privacy Policy outlines how we collect, use, and protect your personal information when you use our service.',
            'is_active' => true,
        ]);

        // Create Terms of Service page
        Page::create([
            'title' => 'Terms of Service',
            'slug' => 'terms-of-service',
            'content' => '<h2>Terms of Service</h2>
<p>Last updated: ' . now()->format('F d, Y') . '</p>

<p>Please read these Terms of Service carefully before using our service.</p>

<h3>1. Acceptance of Terms</h3>
<p>By accessing or using our service, you agree to be bound by these Terms. If you disagree with any part of the terms, then you may not access the service.</p>

<h3>2. Description of Service</h3>
<p>Our service provides a platform for users to create and manage SaaS applications. The service is provided "as is" and "as available" without warranties of any kind.</p>

<h3>3. User Accounts</h3>
<p>When you create an account with us, you must provide information that is accurate, complete, and current at all times. Failure to do so constitutes a breach of the Terms, which may result in immediate termination of your account on our service.</p>

<h3>4. Intellectual Property</h3>
<p>The service and its original content, features, and functionality are and will remain the exclusive property of our company and its licensors. The service is protected by copyright, trademark, and other laws of both the United States and foreign countries.</p>

<h3>5. Termination</h3>
<p>We may terminate or suspend your account immediately, without prior notice or liability, for any reason whatsoever, including without limitation if you breach the Terms.</p>

<h3>6. Limitation of Liability</h3>
<p>In no event shall our company, nor its directors, employees, partners, agents, suppliers, or affiliates, be liable for any indirect, incidental, special, consequential or punitive damages, including without limitation, loss of profits, data, use, goodwill, or other intangible losses, resulting from your access to or use of or inability to access or use the service.</p>

<h3>7. Changes to Terms</h3>
<p>We reserve the right, at our sole discretion, to modify or replace these Terms at any time. If a revision is material we will try to provide at least 30 days notice prior to any new terms taking effect.</p>

<h3>8. Contact Us</h3>
<p>If you have any questions about these Terms, please contact us.</p>',
            'meta_description' => 'Our Terms of Service outline the rules and guidelines for using our platform and services.',
            'is_active' => true,
        ]);
    }
}
