import { usePage } from '@inertiajs/react';
import React, { useEffect, useState, useMemo } from 'react';
import { SharedData } from '@/types';

type FlashMessageType = {
    success?: string;
    error?: string;
    message?: string;
    errors?: {
        email?: string;
    };
};

const GlobalNotification = () => {
    const pageProps = usePage<SharedData & { flash?: FlashMessageType }>().props;
    const flash = useMemo(() => pageProps.flash || {} as FlashMessageType, [pageProps.flash]);
    const [isVisible, setIsVisible] = useState(true);

    // Debug what's available in flash
    useEffect(() => {
        console.log('GlobalNotification - Flash:', flash);
        // Check if flash has success or error or other properties
        if (flash) {
            console.log('Flash properties:', Object.keys(flash));
        }
    }, [flash]);

    // Hide notification after 5 seconds
    useEffect(() => {
        if (flash) {
            // Check all possible flash message formats
            const hasMessage = flash?.success || flash?.error || flash?.message || (typeof flash === 'string');
            if (hasMessage) {
                console.log('Found flash message:', hasMessage);
                const timer = setTimeout(() => setIsVisible(false), 5000);
                return () => clearTimeout(timer);
            }
        }
    }, [flash]);

    // If no flash message, return null
    if (!flash) return null;
    if (!isVisible) return null;

    // Check for any valid message format
    const message = flash?.success || flash?.error || flash?.message || (typeof flash === 'string' ? flash : null);
    if (!message) return null;

    const isSuccess = !!flash?.success || (flash?.message && !flash?.error);

    return (
        <div className="fixed top-4 right-4 z-50 max-w-md">
            <div className={`rounded-lg p-4 shadow-lg ${isSuccess ? 'bg-green-50 border border-green-200 text-green-800 dark:bg-green-900/20 dark:border-green-800 dark:text-green-300' : 'bg-red-50 border border-red-200 text-red-800 dark:bg-red-900/20 dark:border-red-800 dark:text-red-300'}`}>
                <div className="flex items-center">
                    {isSuccess ? (
                        <svg xmlns="http://www.w3.org/2000/svg" className="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                            <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
                        </svg>
                    ) : (
                        <svg xmlns="http://www.w3.org/2000/svg" className="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                            <path fillRule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clipRule="evenodd" />
                        </svg>
                    )}
                    <p>{message}</p>
                    <button
                        onClick={() => setIsVisible(false)}
                        className="ml-auto text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200"
                    >
                        <svg xmlns="http://www.w3.org/2000/svg" className="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                            <path fillRule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clipRule="evenodd" />
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    );
};

export default GlobalNotification;
