import { Link, usePage } from '@inertiajs/react';
import { motion } from 'framer-motion';
import { SharedData } from '@/types';

const Header = () => {
    const { auth } = usePage<SharedData>().props;

    return (
        <header className="relative w-full border-b border-gray-200 dark:border-gray-800 bg-white/80 dark:bg-gray-950/80 backdrop-blur-md">
            <div className="container mx-auto flex h-16 items-center justify-between px-4 lg:px-8">
                <motion.div
                    initial={{ opacity: 0, y: -10 }}
                    animate={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.5 }}
                    className="flex items-center gap-2"
                >
                    <div className="h-8 w-8 rounded-lg bg-indigo-600 flex items-center justify-center text-white font-bold">SL</div>
                    <span className="text-xl font-bold tracking-tight font-jakarta">SaaSLarkit</span>
                </motion.div>

                <nav className="flex items-center gap-6">
                    {auth.user ? (
                        <Link
                            href={route('dashboard')}
                            className="inline-flex h-9 items-center justify-center rounded-md bg-indigo-600 px-4 text-sm font-medium text-white shadow-sm transition-colors hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-950"
                        >
                            Dashboard
                        </Link>
                    ) : (
                        <>
                            <div className="hidden lg:flex items-center gap-6">
                                <Link href="#features" className="text-sm font-medium hover:text-indigo-600 dark:hover:text-indigo-400 transition-colors">
                                    Features
                                </Link>
                                <Link href="#pricing" className="text-sm font-medium hover:text-indigo-600 dark:hover:text-indigo-400 transition-colors">
                                    Pricing
                                </Link>
                                <Link href="#testimonials" className="text-sm font-medium hover:text-indigo-600 dark:hover:text-indigo-400 transition-colors">
                                    Testimonials
                                </Link>
                            </div>
                            <div className="flex items-center gap-3">
                                <Link
                                    href={route('login')}
                                    className="inline-flex h-9 items-center justify-center rounded-md border border-gray-200 bg-white px-4 text-sm font-medium shadow-sm transition-colors hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:border-gray-800 dark:bg-gray-900 dark:hover:bg-gray-800 dark:focus:ring-offset-gray-950"
                                >
                                    Log in
                                </Link>
                                <Link
                                    href={route('register')}
                                    className="inline-flex h-9 items-center justify-center rounded-md bg-indigo-600 px-4 text-sm font-medium text-white shadow-sm transition-colors hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-950"
                                >
                                    Sign up
                                </Link>
                            </div>
                        </>
                    )}
                </nav>
            </div>
        </header>
    );
};

export default Header;
