import { type SharedData } from '@/types';
import { Head, usePage } from '@inertiajs/react';
import { useRef } from 'react';
import PricingPlans from '@/components/pricing/PricingPlans';
import EmailSignupSection from '@/components/EmailSignupSection';
import GlobalNotification from '@/components/layout/GlobalNotification';
import Header from '@/components/layout/Header';
import Footer from '@/components/layout/Footer';
import HeroSection from '@/components/welcome/HeroSection';
import ProjectInfoSection from '@/components/welcome/ProjectInfoSection';
import FeaturesSection from '@/components/welcome/FeaturesSection';
import TestimonialsSection from '@/components/welcome/TestimonialsSection';
import FaqSection from '@/components/welcome/FaqSection';

type FaqType = {
    id: number;
    question: string;
    answer: string;
    order: number;
    is_active: boolean;
    created_at: string;
    updated_at: string;
};

type TestimonialType = {
    id: number;
    name: string;
    role: string;
    company: string;
    content: string;
    avatar: string;
    rating: number;
    order: number;
    is_active: boolean;
    created_at: string;
    updated_at: string;
};

type FeatureType = {
    id: number;
    title: string;
    description: string;
    icon: string;
    order: number;
    is_active: boolean;
    created_at: string;
    updated_at: string;
};

type WhatToExpectType = {
    id: number;
    title: string;
    description: string;
    icon: string;
    order: number;
    is_active: boolean;
    created_at: string;
    updated_at: string;
};

export default function Welcome() {
    const pageProps = usePage<SharedData & {
        faqs?: FaqType[],
        testimonials?: TestimonialType[],
        features?: FeatureType[],
        whatToExpect?: WhatToExpectType[]
    }>().props;

    const { auth } = pageProps;
    const faqs = pageProps.faqs || [];
    const testimonials = pageProps.testimonials || [];
    const features = pageProps.features || [];
    const whatToExpect = pageProps.whatToExpect || [];
    const emailSectionRef = useRef<HTMLDivElement | null>(null);

    return (
        <>
            <Head title="Modern SaaS Starter Kit">
                <link rel="preconnect" href="https://fonts.bunny.net" />
                <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600|plus-jakarta-sans:500,600,700,800" rel="stylesheet" />
            </Head>

            {/* Global notification for redirects */}
            <GlobalNotification />

            <div className="min-h-screen bg-gradient-to-b from-white to-gray-50 dark:from-gray-950 dark:to-gray-900 text-gray-900 dark:text-gray-100">
                {/* Header */}
                <Header />

                {/* Hero Section */}
                <HeroSection />

                {/* Project Information Section */}
                <ProjectInfoSection
                    whatToExpect={whatToExpect}
                    emailSectionRef={emailSectionRef}
                />

                {/* Features Section */}
                <FeaturesSection features={features} />

                {/* Testimonials Section */}
                <TestimonialsSection testimonials={testimonials} />

                {/* Email Signup Section */}
                <EmailSignupSection emailSectionRef={emailSectionRef} />

                {/* Pricing Section */}
                <section id="pricing" className="py-16 md:py-20 bg-white dark:bg-gray-950">
                    <div className="container px-4 md:px-6 mx-auto max-w-7xl">
                        <div className="text-center mb-12 md:mb-16">
                            <h2 className="text-3xl font-bold tracking-tight sm:text-4xl md:text-5xl font-jakarta">Simple, Transparent Pricing</h2>
                            <p className="mt-4 text-gray-500 md:text-xl/relaxed lg:text-base/relaxed xl:text-xl/relaxed dark:text-gray-400">
                                Choose the plan that works best for your business. No hidden fees or surprises.
                            </p>
                        </div>

                        <PricingPlans auth={auth} />
                    </div>
                </section>

                {/* FAQ Section */}
                <FaqSection faqs={faqs} />

                {/* Footer */}
                <Footer />
            </div>
        </>
    );
}
