<?php

namespace App\Extensions\Installed\Importer\Livewire\Api;

use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Extensions\Installed\Importer\Models\ImportJob;
use App\Extensions\Installed\Importer\Services\ApiImporter;

#[Layout('components.layouts.app', ['title' => 'API Import Process', 'noPadding' => true])]
class Process extends Component
{
    public ImportJob $job;
    public $result = null;
    public $error = null;

    public function mount(ImportJob $job)
    {
        $this->job = $job;
        $this->result = null;
        $this->error = null;
    }

    public function runChunk()
    {
        try {
            $importer = new ApiImporter($this->job->fresh());
            $this->result = $importer->process(true);
            $this->job->refresh();
        } catch (\Throwable $e) {
            $this->error = $e->getMessage();
        }
    }

    public function runAll()
    {
        try {
            $importer = new ApiImporter($this->job->fresh());
            $this->result = $importer->process(false);
            $this->job->refresh();
        } catch (\Throwable $e) {
            $this->error = $e->getMessage();
        }
    }

    public function render()
    {
        return view('extension.importer::api.process');
    }
}
