<?php

namespace App\Extensions\Installed\Importer\Livewire;

use Livewire\Component;
use App\Extensions\Installed\Importer\Models\ImportJob;

class Index extends Component
{
    public function render()
    {
        return view('extension.importer::index', [
            'recentJobs' => ImportJob::latest()->take(5)->get(),
            'sources' => $this->sourceConfig(),
        ])->layout('components.layouts.app', ['title' => 'Import Data', 'noPadding' => true]);
    }

    /**
     * Prepare the source configuration for the importer cards.
     */
    protected function sourceConfig(): array
    {
        $defaults = [
            'csv' => [
                'enabled' => true,
                'name' => 'CSV Import',
                'description' => 'Upload CSV files to import customers, tickets, responses, or announcements. Includes field mapping, data preview, and batch processing.',
            ],
            'database' => [
                'enabled' => true,
                'name' => 'Database Import',
                'description' => 'Connect directly to a database to migrate customers, tickets, and responses with automatic ID mapping.',
            ],
        ];

        $configured = config('extensions.importer.sources');

        if (!is_array($configured)) {
            return $defaults;
        }

        return array_replace_recursive($defaults, $configured);
    }
}