<?php

namespace App\Extensions\Installed\Importer\Services\DatabaseAdapters;

/**
 * ClientExec database adapter (scaffolding).
 */
class ClientExecAdapter extends AbstractDatabaseImportAdapter
{
    public static function id(): string
    {
        return 'clientexec';
    }

    public static function label(): string
    {
        return 'ClientExec';
    }

    public static function defaults(): array
    {
        return [
            'chunk_size' => 100,
            'options' => [
                'import_departments' => true,
                'import_categories' => true,
                'import_users' => true,
                'import_operators' => true,
                'import_tickets' => true,
                'import_responses' => true,
                'import_articles' => true,
            ],
        ];
    }

    public static function isPreview(): bool
    {
        return true;
    }

    public function stages(): array
    {
        return [
            'departments',
            'categories',
            'users',
            'operators',
            'tickets',
            'responses',
            'articles',
        ];
    }

    public function count(string $stage): int
    {
        return 0;
    }

    public function fetch(string $stage, int $offset, int $limit): array
    {
        return [];
    }

    public function mapStatus(?int $statusId): string
    {
        return match ($statusId) {
            5 => 'closed',
            3 => 'awaiting reply',
            2 => 'in progress',
            default => 'open',
        };
    }

    public function mapPriority(?int $priorityId): string
    {
        return match ($priorityId) {
            4 => 'emergency',
            3 => 'high',
            2 => 'medium',
            1 => 'low',
            default => 'none',
        };
    }

    public function isOperatorUser(int $userId): bool
    {
        return false;
    }

    public function findUser(int $userId): ?array
    {
        return null;
    }
}

