<?php

use App\Extensions\Concerns\ChecksExtensionInstallation;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\{DB, Schema};

return new class extends Migration
{
    use ChecksExtensionInstallation;

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('importer_jobs')) {
            return;
        }

        // Normalize any legacy values before updating the enum definition.
        DB::table('importer_jobs')
            ->whereNotIn('type', ['customers', 'tickets', 'responses', 'announcements', 'departments'])
            ->update(['type' => 'database']);

        DB::statement("
            ALTER TABLE `importer_jobs`
            MODIFY `source` ENUM('csv', 'database', 'supportpal', 'blesta', 'whmcs', 'clientexec') NOT NULL
        ");

        DB::statement("
            ALTER TABLE `importer_jobs`
            MODIFY `type` ENUM('customers', 'tickets', 'responses', 'announcements', 'departments', 'database') NOT NULL
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Skip rollback if extension is not installed
        if ($this->shouldSkipRollback('importer')) {
            return;
        }

        if (!Schema::hasTable('importer_jobs')) {
            return;
        }

        // Convert database imports back to a legacy-safe type before reverting enum.
        DB::table('importer_jobs')
            ->where('type', 'database')
            ->update(['type' => 'tickets']);

        DB::statement("
            ALTER TABLE `importer_jobs`
            MODIFY `source` ENUM('csv', 'supportpal') NOT NULL
        ");

        DB::statement("
            ALTER TABLE `importer_jobs`
            MODIFY `type` ENUM('customers', 'tickets', 'responses', 'announcements', 'departments') NOT NULL
        ");
    }
};