<?php

use Illuminate\Support\Facades\Route;
use App\Extensions\Installed\Importer\Livewire\Index;
use App\Extensions\Installed\Importer\Livewire\Csv\Upload;
use App\Extensions\Installed\Importer\Livewire\Csv\Mapping;
use App\Extensions\Installed\Importer\Livewire\Csv\Process;
use App\Extensions\Installed\Importer\Livewire\Jobs\JobsIndex;
use App\Extensions\Installed\Importer\Livewire\Database\Configure as DatabaseConfigure;
use App\Extensions\Installed\Importer\Livewire\Database\Process as DatabaseProcess;
use App\Extensions\Installed\Importer\Livewire\Api\Configure as ApiConfigure;
use App\Extensions\Installed\Importer\Livewire\Api\Process as ApiProcess;

Route::get("/", Index::class)->name("extensions.importer.index");

Route::prefix("csv")
    ->name("extensions.importer.csv.")
    ->group(function () {
        Route::get("/upload", Upload::class)->name("upload");
        Route::get("/mapping/{jobId}", Mapping::class)->name("mapping");
        Route::get("/process/{jobId}", Process::class)->name("process");
    });

Route::get("database/configure", DatabaseConfigure::class)
    ->name("extensions.importer.database.configure");
Route::get("database/process/{job}", DatabaseProcess::class)
    ->name("extensions.importer.database.process");

Route::get("api/configure", ApiConfigure::class)
    ->name("extensions.importer.api.configure");
Route::get("api/process/{job}", ApiProcess::class)
    ->name("extensions.importer.api.process");

Route::get("/jobs", JobsIndex::class)->name("extensions.importer.jobs.index");
Route::get("/history", JobsIndex::class)->name("extensions.importer.history");
