<div>
@include('extension.importer::partials.navigation')

<div class="container mx-auto px-8 py-8">
    @if (session('error'))
        <div class="mb-6 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg">
            {{ session('error') }}
        </div>
    @endif

    @if (session('message'))
        <div class="mb-6 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg">
            {{ session('message') }}
        </div>
    @endif

    @if($testError)
        <div class="mb-6 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg">
            {{ $testError }}
        </div>
    @endif

    <!-- Page Header -->
    <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm p-6">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl font-semibold text-gray-900 dark:text-white">API Import Configuration</h1>
            </div>
            <span class="inline-flex items-center rounded-full border border-green-200/70 dark:border-green-500/40 bg-green-50 dark:bg-green-500/10 px-3 py-1 text-sm font-medium text-green-600 dark:text-green-300">
                API Import
            </span>
        </div>
    </div>

    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6 mt-6">
        <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-6">API Connection Settings</h2>

        <div class="space-y-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Source System <span class="text-red-500">*</span>
                </label>
                <select wire:model="system" wire:change="$refresh"
                        class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 focus:ring-indigo-500 focus:border-indigo-500">
                    @foreach($systems as $adapter)
                        <option value="{{ $adapter['id'] }}" @disabled($adapter['preview'] ?? false)>
                            {{ $adapter['label'] }}{{ ($adapter['preview'] ?? false) ? ' (Coming Soon)' : '' }}
                        </option>
                    @endforeach
                </select>
                @if($adapterPreview)
                    <p class="text-sm text-amber-600 dark:text-amber-300 mt-2">
                        This adapter is in preview and cannot run imports yet.
                    </p>
                @endif
                @error('system') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Base URL @if($requiredFields['base_url'] ?? false)<span class="text-red-500">*</span>@endif
                    </label>
                    <input type="url" wire:model="base_url"
                           class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 focus:ring-indigo-500 focus:border-indigo-500"
                           placeholder="{{ $baseUrlPlaceholder }}">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        Your full API domain URL
                    </p>
                    @error('base_url') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
                </div>

                @if(isset($requiredFields['subdomain']) && $requiredFields['subdomain'] !== false)
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Subdomain <span class="text-xs text-gray-500">(Optional - alternative to Base URL)</span>
                    </label>
                    <input type="text" wire:model="subdomain"
                           class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 focus:ring-indigo-500 focus:border-indigo-500"
                           placeholder="your-subdomain">
                    @error('subdomain') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
                </div>
                @endif

                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        API Key @if($requiredFields['api_key'] ?? false)<span class="text-red-500">*</span>@endif
                    </label>
                    <input type="text" wire:model="api_key" autocomplete="off"
                           class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 focus:ring-indigo-500 focus:border-indigo-500"
                           placeholder="API key">
                    @error('api_key') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
                </div>

                @if(isset($requiredFields['username']) && $requiredFields['username'] !== false)
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Username / Email @if($requiredFields['username'] ?? false)<span class="text-red-500">*</span>@else<span class="text-xs text-gray-500">(Optional)</span>@endif
                    </label>
                    <input type="text" wire:model="username"
                           class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 focus:ring-indigo-500 focus:border-indigo-500"
                           placeholder="user@example.com">
                    @error('username') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
                </div>
                @endif

                @if(isset($requiredFields['token']) && $requiredFields['token'] !== false)
                <div>
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Token / Password @if($requiredFields['token'] ?? false)<span class="text-red-500">*</span>@else<span class="text-xs text-gray-500">(Optional)</span>@endif
                    </label>
                    <input type="password" wire:model="token" autocomplete="new-password"
                           class="w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-200 focus:ring-indigo-500 focus:border-indigo-500"
                           placeholder="token or password">
                    @error('token') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
                </div>
                @endif
            </div>

            <div class="flex justify-end pt-4 border-t border-gray-200 dark:border-gray-700">
                <button type="button" wire:click="testConnection"
                        @disabled($adapterPreview)
                        class="inline-flex items-center px-4 py-2 bg-indigo-600 hover:bg-indigo-700 disabled:bg-gray-400 disabled:cursor-not-allowed text-white font-medium rounded-lg transition">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    @if($adapterPreview) Coming Soon @else Test Connection @endif
                </button>
            </div>
        </div>
    </div>

    @if($testSuccess && !$adapterPreview)
    <div class="mt-6 bg-green-50 dark:bg-green-900 border border-green-200 dark:border-green-700 rounded-lg p-6">
        <div class="flex items-center mb-4">
            <svg class="w-6 h-6 text-green-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
            </svg>
            <h3 class="text-lg font-semibold text-green-900 dark:text-green-100">Configuration Valid</h3>
        </div>
        <p class="text-sm text-green-800 dark:text-green-200 mb-4">
            API connection successful. You can now start the import process.
        </p>
        <button wire:click="createImportJob"
                class="inline-flex items-center px-6 py-3 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition">
            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM9.555 7.168A1 1 0 008 8v4a1 1 0 001.555.832l3-2a1 1 0 000-1.664l-3-2z" clip-rule="evenodd"/>
            </svg>
            Start API Import
        </button>
    </div>
    @endif

    <div class="mt-6 bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-6">How to Get API Credentials</h3>

        <div class="space-y-6">
            @if($system === 'freshdesk')
            <div class="p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                <h4 class="font-medium text-gray-900 dark:text-white mb-3 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z"/>
                        <path fill-rule="evenodd" d="M4 5a2 2 0 012-2 3 3 0 003 3h2a3 3 0 003-3 2 2 0 012 2v11a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm3 4a1 1 0 000 2h.01a1 1 0 100-2H7zm3 0a1 1 0 000 2h3a1 1 0 100-2h-3zm-3 4a1 1 0 100 2h.01a1 1 0 100-2H7zm3 0a1 1 0 100 2h3a1 1 0 100-2h-3z" clip-rule="evenodd"/>
                    </svg>
                    Freshdesk
                </h4>
                <ol class="list-decimal list-inside space-y-2 text-sm text-gray-700 dark:text-gray-300 ml-4">
                    <li>Log in to your Freshdesk account</li>
                    <li>Click your profile picture → <strong>Profile Settings</strong></li>
                    <li>Find the <strong>API Key</strong> section on the right sidebar</li>
                    <li>Copy your API key</li>
                    <li>Base URL format: <code class="bg-gray-200 dark:bg-gray-600 px-2 py-1 rounded text-xs">https://yourdomain.freshdesk.com</code></li>
                </ol>
            </div>

            <div class="p-4 bg-gray-100 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                <h4 class="font-medium text-gray-900 dark:text-white mb-3 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-indigo-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                    </svg>
                    Rate Limiting Information
                </h4>
                <ul class="space-y-2 text-sm text-gray-700 dark:text-gray-300">
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span><strong>Freshdesk:</strong> 500 requests/min (Garden), 3000/min (higher plans)</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Automatic retry on failures (3 attempts with 1 second delay)</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Large imports (10,000+ records) may take 30+ minutes</span>
                    </li>
                </ul>
            </div>
            @elseif($system === 'zendesk')
            <div class="p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                <h4 class="font-medium text-gray-900 dark:text-white mb-3 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                    Zendesk
                </h4>
                <ol class="list-decimal list-inside space-y-2 text-sm text-gray-700 dark:text-gray-300 ml-4">
                    <li>Log in to your Zendesk account</li>
                    <li>Click <strong>Admin</strong> gear icon → <strong>Apps and integrations</strong> → <strong>APIs</strong> → <strong>Zendesk API</strong></li>
                    <li>Under <strong>Settings</strong> tab, enable <strong>Token Access</strong></li>
                    <li>Click the <strong>+</strong> button to generate a new API token</li>
                    <li>Copy the token immediately (it won't be shown again)</li>
                    <li>Your subdomain is the part before <code class="bg-gray-200 dark:bg-gray-600 px-2 py-1 rounded text-xs">.zendesk.com</code></li>
                </ol>
                <div class="mt-3 p-3 bg-amber-50 dark:bg-amber-900/20 border-l-4 border-amber-400 rounded">
                    <p class="text-sm text-amber-800 dark:text-amber-200">
                        <strong>Note:</strong> Zendesk requires Username (your email), Token (API token), and either Subdomain or Base URL.
                    </p>
                </div>
            </div>

            <div class="p-4 bg-gray-100 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                <h4 class="font-medium text-gray-900 dark:text-white mb-3 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-indigo-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                    </svg>
                    Rate Limiting Information
                </h4>
                <ul class="space-y-2 text-sm text-gray-700 dark:text-gray-300">
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span><strong>Zendesk:</strong> 700 requests/min (Professional), 2500/min (Enterprise)</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Automatic retry on failures (3 attempts with 1 second delay)</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Large imports (10,000+ records) may take 30+ minutes</span>
                    </li>
                </ul>
            </div>
            @elseif($system === 'helpscout')
            <div class="p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                <h4 class="font-medium text-gray-900 dark:text-white mb-3 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-blue-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                    HelpScout
                </h4>
                <ol class="list-decimal list-inside space-y-2 text-sm text-gray-700 dark:text-gray-300 ml-4">
                    <li>Log in to your HelpScout account</li>
                    <li>Click your profile picture → <strong>Your Profile</strong> → <strong>My Apps</strong></li>
                    <li>Click <strong>Create My App</strong></li>
                    <li>Enter an App Name (e.g., "Ticaga Import")</li>
                    <li>Select <strong>Redirection URL:</strong> Not required for import-only apps</li>
                    <li>Click <strong>Create</strong></li>
                    <li>Copy the <strong>App ID</strong> (use as API Key)</li>
                    <li>Copy the <strong>App Secret</strong> (use as Token/Password)</li>
                </ol>
                <div class="mt-3 p-3 bg-blue-50 dark:bg-blue-900/20 border-l-4 border-blue-400 rounded">
                    <p class="text-sm text-blue-800 dark:text-blue-200">
                        <strong>Note:</strong> HelpScout uses OAuth 2.0. The App ID and App Secret will be used to automatically obtain an access token (valid for 2 days).
                    </p>
                </div>
            </div>

            <div class="p-4 bg-gray-100 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600">
                <h4 class="font-medium text-gray-900 dark:text-white mb-3 flex items-center">
                    <svg class="w-5 h-5 mr-2 text-indigo-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
                    </svg>
                    Rate Limiting & Import Information
                </h4>
                <ul class="space-y-2 text-sm text-gray-700 dark:text-gray-300">
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span><strong>HelpScout:</strong> 200 requests per 15 seconds (~800/min)</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>OAuth tokens automatically managed (2-day validity)</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Automatic retry on failures (3 attempts with 1 second delay)</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Imports: Mailboxes (departments), Customers (users), and Conversations (tickets)</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-indigo-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Pagination: 50 items per page (25 for conversations)</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-4 h-4 text-amber-600 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                        </svg>
                        <span><strong>Note:</strong> HelpScout doesn't use ticket priorities - all imported tickets will have priority "none"</span>
                    </li>
                </ul>
            </div>
            @endif
        </div>
    </div>
</div>
</div>
