<div>
@include('extension.importer::partials.navigation')

<div class="container mx-auto px-8 py-8">
    <div class="space-y-6 pb-16">

    <!-- Page Header -->
    <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm p-6">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl font-semibold text-gray-900 dark:text-white">Upload CSV File</h1>
                <p class="mt-2 text-sm text-gray-600 dark:text-gray-400 max-w-2xl">
                    Step 1 of 3. Upload your CSV file and confirm the structure before mapping columns to Ticaga fields.
                </p>
            </div>
            <span class="inline-flex items-center rounded-full border border-indigo-200/70 dark:border-indigo-500/40 bg-indigo-50 dark:bg-indigo-500/10 px-3 py-1 text-sm font-medium text-indigo-600 dark:text-indigo-300">
                CSV Import
            </span>
        </div>
    </div>

    @if (session('error'))
        <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 rounded-xl px-4 py-3">
            {{ session('error') }}
        </div>
    @endif

    @if (session('success'))
        <div class="bg-emerald-50 dark:bg-emerald-900/20 border border-emerald-200 dark:border-emerald-800 text-emerald-700 dark:text-emerald-200 rounded-xl px-4 py-3">
            {{ session('success') }}
        </div>
    @endif

    <div class="grid gap-6 lg:grid-cols-3 lg:items-start">
        <!-- Upload Form -->
        <div class="space-y-6 lg:col-span-2">
            <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm p-6">
                <form wire:submit.prevent="uploadFile" class="space-y-8">
                    <div class="grid gap-6 md:grid-cols-2">
                        <div class="space-y-2">
                            <label class="block text-sm font-medium text-gray-900 dark:text-white">
                                Import Name <span class="text-xs font-normal text-gray-500 dark:text-gray-400">(optional)</span>
                            </label>
                            <input type="text"
                                   wire:model.defer="importName"
                                   placeholder="e.g. Customer Migration 2024"
                                   class="w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-gray-100 focus:border-indigo-500 focus:ring-indigo-500" />
                            <p class="text-xs text-gray-500 dark:text-gray-400">
                                Give this import a friendly name for quick reference later.
                            </p>
                        </div>

                        <div class="space-y-2">
                            <label class="block text-sm font-medium text-gray-900 dark:text-white">
                                What are you importing?
                            </label>
                            <select wire:model.live="importType"
                                    class="w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-gray-100 focus:border-indigo-500 focus:ring-indigo-500">
                                @foreach($importTypes as $key => $type)
                                    <option value="{{ $key }}">{{ $type['name'] ?? ucfirst($key) }}</option>
                                @endforeach
                            </select>
                            <p class="text-xs text-gray-500 dark:text-gray-400">
                                Select the dataset contained in your CSV file.
                            </p>
                            @error('importType') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div class="space-y-2"
                         x-data="{
                             isDropping: false,
                             handleDrop(event) {
                                 this.isDropping = false;
                                 const files = event.dataTransfer.files;
                                 if (!files || !files.length) return;
                                 this.$refs.csvInput.files = files;
                                 this.$refs.csvInput.dispatchEvent(new Event('change', { bubbles: true }));
                             }
                         }"
                         x-on:dragover.prevent="isDropping = true"
                         x-on:dragleave.prevent="isDropping = false"
                         x-on:drop.prevent="handleDrop($event)">
                        <label class="block text-sm font-medium text-gray-900 dark:text-white">
                            CSV File
                        </label>
                        <label class="flex flex-col items-center justify-center w-full h-40 border-2 border-dashed rounded-xl bg-gray-50 dark:bg-gray-800/60 border-gray-300 dark:border-gray-600 transition-colors cursor-pointer"
                               :class="isDropping ? 'border-indigo-400 bg-indigo-50/80 dark:border-indigo-500 dark:bg-indigo-500/10' : 'hover:border-indigo-400 dark:hover:border-indigo-500'">
                            <div class="flex flex-col items-center justify-center pt-5 pb-6 text-center">
                                <x-heroicon-o-arrow-up-tray class="w-12 h-12 mb-3 text-gray-400 dark:text-gray-500" />
                                <p class="text-sm text-gray-600 dark:text-gray-300">
                                    <span class="font-semibold">Click to upload</span> or drag and drop
                                </p>
                                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                                    CSV or TXT file • Max {{ $maxFileSizeMB }}MB
                                </p>
                            </div>
                            <input x-ref="csvInput" type="file" class="hidden" wire:model="file" accept=".csv,.txt" />
                        </label>
                        @if($file)
                            <p class="text-sm text-emerald-600 dark:text-emerald-300 mt-2 flex items-center gap-2">
                                <x-heroicon-s-check-circle class="w-5 h-5" />
                                {{ $file->getClientOriginalName() }}
                            </p>
                        @endif
                        @error('file') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
                    </div>

                    <div class="flex items-center justify-between mt-8 gap-4">
                        <a href="{{ route('extensions.importer.index') }}"
                           class="inline-flex items-center justify-center min-w-[160px] px-4 py-3 rounded-xl border border-gray-300 dark:border-gray-600 text-sm font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-800 transition">
                            Cancel
                        </a>
                        <button type="submit"
                                wire:loading.attr="disabled"
                                class="inline-flex items-center justify-center min-w-[200px] px-5 py-3 rounded-xl bg-indigo-600 hover:bg-indigo-700 text-white font-medium shadow-sm transition disabled:opacity-60">
                            <span wire:loading.remove class="flex items-center font-medium">
                                <x-heroicon-s-arrow-right class="w-5 h-5 mr-2" />
                                Continue to Mapping
                            </span>
                            <span wire:loading class="flex items-center">
                                <x-heroicon-s-arrow-path class="w-5 h-5 mr-2 animate-spin" />
                                Uploading…
                            </span>
                        </button>
                    </div>
                </form>
            </div>

            <!-- Required Fields -->
            <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Required Fields</h3>
                <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                    We detected the <span class="font-medium text-indigo-600 dark:text-indigo-300">{{ $selectedType['name'] }}</span> import type.
                    Make sure your file includes:
                </p>
                <ul class="mt-4 space-y-2 text-sm text-gray-700 dark:text-gray-200">
                    @forelse($requiredFields as $field)
                        <li class="flex items-center gap-2">
                            <x-heroicon-s-check class="w-4 h-4 text-emerald-500" />
                            <span class="capitalize">{{ str_replace('_', ' ', $field) }}</span>
                        </li>
                    @empty
                        <li class="text-gray-500 dark:text-gray-400">No required fields configured.</li>
                    @endforelse
                </ul>
                @if(!empty($optionalFields))
                    <p class="mt-4 text-sm text-gray-500 dark:text-gray-400">
                        Optional fields:
                        <span class="text-gray-700 dark:text-gray-200">
                            {{ collect($optionalFields)->map(fn($field) => str_replace('_', ' ', $field))->implode(', ') }}
                        </span>
                    </p>
                @endif
            </div>

        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">CSV Requirements</h3>
                <dl class="mt-4 space-y-4 text-sm text-gray-600 dark:text-gray-300">
                    <div>
                        <dt class="font-semibold text-gray-900 dark:text-white">File Format</dt>
                        <dd class="mt-1">Upload a CSV or TXT file using comma-separated values.</dd>
                    </div>
                    <div>
                        <dt class="font-semibold text-gray-900 dark:text-white">Headers Required</dt>
                        <dd class="mt-1">Ensure the first row contains the column names to map fields correctly.</dd>
                    </div>
                    <div>
                        <dt class="font-semibold text-gray-900 dark:text-white">Size Limit</dt>
                        <dd class="mt-1">Maximum file size {{ $maxFileSizeMB }}MB per upload.</dd>
                    </div>
                    <div>
                        <dt class="font-semibold text-gray-900 dark:text-white">Encoding</dt>
                        <dd class="mt-1">Recommended UTF-8 to avoid invalid characters.</dd>
                    </div>
                </dl>
            </div>

            <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Helpful Tips</h3>
                <ul class="mt-4 space-y-3 text-sm text-gray-600 dark:text-gray-300">
                    <li class="flex items-start gap-3">
                        <x-heroicon-o-adjustments-horizontal class="w-9 h-9 mt-0.5 text-indigo-500" />
                        <span>Normalize data before importing (consistent status, priorities, and date formats).</span>
                    </li>
                    <li class="flex items-start gap-3">
                        <x-heroicon-o-table-cells class="w-9 h-9 mt-0.5 text-indigo-500" />
                        <span>Remove unused columns or fill missing headers to avoid mapping confusion.</span>
                    </li>
                    <li class="flex items-start gap-3">
                        <x-heroicon-o-shield-check class="w-9 h-9 mt-0.5 text-indigo-500" />
                        <span>Double-check that you're not uploading sensitive information unintentionally.</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    </div>
</div>
</div>
