<div>
@include('extension.importer::partials.navigation')

<div class="container mx-auto px-8 py-8">
    <div class="space-y-6">

        @if (session('error'))
            <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded">
                {{ session('error') }}
            </div>
        @endif

        @if (session('message'))
            <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded">
                {{ session('message') }}
            </div>
        @endif

        <!-- Page Header -->
        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm p-6">
            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
                <div>
                    <h1 class="text-2xl font-semibold text-gray-900 dark:text-white">Database Import Configuration</h1>
                </div>
                <span class="inline-flex items-center rounded-full border border-purple-200/70 dark:border-purple-500/40 bg-purple-50 dark:bg-purple-500/10 px-3 py-1 text-sm font-medium text-purple-600 dark:text-purple-300">
                    Database Import
                </span>
            </div>
        </div>

        <!-- Configuration Form -->
        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm p-6">
            <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-6">Database Connection Settings</h2>

            <form wire:submit="testConnection" class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- System -->
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Source System *
                        </label>
                        <select wire:model="system"
                                wire:change="$refresh"
                                class="w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-gray-100 focus:border-indigo-500 focus:ring-indigo-500">
                            @foreach($systems as $adapter)
                                <option value="{{ $adapter['id'] }}"
                                        @disabled($adapter['preview'] ?? false)>
                                    {{ $adapter['label'] }}{{ ($adapter['preview'] ?? false) ? ' (Coming Soon)' : '' }}
                                </option>
                            @endforeach
                        </select>
                        @if($adapterPreview)
                            <p class="text-sm text-amber-600 dark:text-amber-300 mt-2">
                                This adapter is in preview and cannot run imports yet.
                            </p>
                        @endif
                        @error('system') <span class="text-sm text-red-600 dark:text-red-400 mt-1">{{ $message }}</span> @enderror
                    </div>

                    <!-- Host -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Database Host *
                        </label>
                        <input type="text"
                               wire:model="host"
                               class="w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-gray-100 focus:border-indigo-500 focus:ring-indigo-500"
                               placeholder="localhost">
                        @error('host') <span class="text-sm text-red-600 dark:text-red-400 mt-1">{{ $message }}</span> @enderror
                    </div>

                    <!-- Port -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Database Port *
                        </label>
                        <input type="number"
                               wire:model="port"
                               class="w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-gray-100 focus:border-indigo-500 focus:ring-indigo-500"
                               placeholder="3306">
                        @error('port') <span class="text-sm text-red-600 dark:text-red-400 mt-1">{{ $message }}</span> @enderror
                    </div>

                    <!-- Database Name -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Database Name *
                        </label>
                        <input type="text"
                               wire:model="database"
                               class="w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-gray-100 focus:border-indigo-500 focus:ring-indigo-500"
                               placeholder="{{ $databasePlaceholder }}">
                        @error('database') <span class="text-sm text-red-600 dark:text-red-400 mt-1">{{ $message }}</span> @enderror
                    </div>

                    <!-- Table Prefix -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Table Prefix
                        </label>
                        <input type="text"
                               wire:model="prefix"
                               class="w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-gray-100 focus:border-indigo-500 focus:ring-indigo-500"
                               placeholder="{{ $prefixPlaceholder }}">
                        @error('prefix') <span class="text-sm text-red-600 dark:text-red-400 mt-1">{{ $message }}</span> @enderror
                    </div>

                    <!-- Username -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Database Username *
                        </label>
                        <input type="text"
                               wire:model="username"
                               autocomplete="off"
                               class="w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-gray-100 focus:border-indigo-500 focus:ring-indigo-500"
                               placeholder="root">
                        @error('username') <span class="text-sm text-red-600 dark:text-red-400 mt-1">{{ $message }}</span> @enderror
                    </div>

                    <!-- Password -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Database Password
                        </label>
                        <input type="password"
                               wire:model="password"
                               autocomplete="new-password"
                               class="w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-800 dark:text-gray-100 focus:border-indigo-500 focus:ring-indigo-500"
                               placeholder="••••••••">
                        @error('password') <span class="text-sm text-red-600 dark:text-red-400 mt-1">{{ $message }}</span> @enderror
                    </div>
                </div>

                <!-- Connection Status -->
                @if($testSuccess)
                <div class="p-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg">
                    <div class="flex items-center text-green-800 dark:text-green-200">
                        <x-heroicon-s-check-circle class="h-5 w-5 mr-2" />
                        <span class="font-medium">Connection Successful!</span>
                    </div>
                </div>
                @endif

                @if($testError)
                <div class="p-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg">
                    <div class="flex items-start text-red-800 dark:text-red-200">
                        <x-heroicon-s-x-circle class="h-5 w-5 mr-2 flex-shrink-0 mt-0.5" />
                        <div>
                            <span class="font-medium">Connection Failed</span>
                            <p class="text-sm mt-1">{{ $testError }}</p>
                        </div>
                    </div>
                </div>
                @endif

                <!-- Test Connection Button -->
                <div class="flex items-center justify-between gap-4">
                    <a href="{{ route('extensions.importer.index') }}"
                       class="inline-flex items-center justify-center min-w-[160px] px-4 py-3 rounded-xl border border-gray-300 dark:border-gray-600 text-sm font-medium text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-800 transition">
                        Cancel
                    </a>
                    <button type="submit"
                            @disabled($adapterPreview)
                            class="inline-flex items-center justify-center min-w-[200px] px-5 py-3 rounded-xl bg-indigo-600 hover:bg-indigo-700 disabled:bg-gray-400 disabled:cursor-not-allowed text-white font-medium shadow-sm transition">
                        <x-heroicon-s-signal class="w-5 h-5 mr-2" />
                        @if($adapterPreview)
                            Coming Soon
                        @else
                            Test Connection
                        @endif
                    </button>
                </div>
            </form>
        </div>

        <!-- Start Import -->
        @if($testSuccess && !$adapterPreview)
        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-700 rounded-xl shadow-sm p-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Ready to Import</h3>
            <p class="text-gray-600 dark:text-gray-400 mb-6">
                The connection test was successful. Click the button below to start importing data from {{ $adapterLabel }}.
            </p>

            <button wire:click="createImportJob"
                    class="inline-flex items-center px-6 py-3 bg-emerald-600 hover:bg-emerald-700 text-white font-medium rounded-xl shadow-sm transition">
                <x-heroicon-s-play class="w-5 h-5 mr-2" />
                Start Database Import
            </button>
        </div>
        @endif

        <!-- Warning -->
        <div class="bg-amber-50 dark:bg-amber-900/20 border-l-4 border-amber-400 rounded-lg p-4">
            <div class="flex">
                <x-heroicon-s-exclamation-triangle class="h-5 w-5 text-amber-400 mr-3 flex-shrink-0" />
                <div class="text-sm text-amber-800 dark:text-amber-200">
                    <p class="font-semibold mb-2">Important Notes</p>
                    <ul class="space-y-1 list-disc list-inside">
                        <li>Ensure you have a backup of your Ticaga database before importing.</li>
                        <li>The source database will not be modified (read-only access).</li>
                        <li>Large databases may take significant time to import.</li>
                        <li>Users will be created with a default password and forced to reset on first login.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
