<?php

namespace App\Http\Controllers;

use App\Models\{Announcements,User};
use Illuminate\Http\Request;

use Illuminate\Support\Facades\{Auth,DB};

class AnnouncementsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('announcements.index');
    }

    /**
     * Display the specified resource.
     */
    public function show($id, $slug)
    {
        if(!Auth::guest() && Auth::user()->hasAnyRole('superadmin', 'admin', 'employee'))
        {
            $announcement = Announcements::leftJoin('users', 'announcements.author_id', '=', 'users.id')
                ->leftJoin('categories', 'announcements.parent_category', '=', 'categories.id')
                ->select('announcements.*', 'categories.*', 'users.id')
                ->selectRaw('users.company as company_name, users.id as customer_id, announcements.id as announcement_id, categories.id as category_id, announcements.created_at as announcement_created')
                ->where('announcements.id', '=', $id)->first();
        } else {
            $announcement = Announcements::leftJoin('users', 'announcements.author_id', '=', 'users.id')
                ->leftJoin('categories', 'announcements.parent_category', '=', 'categories.id')
                ->select('announcements.*', 'categories.*', 'users.id')
                ->selectRaw('users.company as company_name, users.id as customer_id, announcements.id as announcement_id, categories.id as category_id, announcements.created_at as announcement_created')
                ->where('announcements.id', '=', $id)->where('announcements.draft', '!=', '1')->first();
        }

        if($announcement)
        {
            $announcementModel = Announcements::find($announcement->announcement_id);

            if($announcementModel) {
                $viewRecorded = false;

                // Track view for authenticated users
                if(!Auth::guest()) {
                    $userId = Auth::id();

                    // Check if this user hasn't viewed this announcement yet
                    if(!$announcementModel->hasBeenViewedByUser($userId)) {
                        // Record the view with user_id
                        \DB::table('announcement_views')->insert([
                            'announcement_id' => $announcementModel->id,
                            'user_id' => $userId,
                            'session_id' => null,
                            'viewed_at' => now(),
                        ]);
                        $viewRecorded = true;
                    }
                } else {
                    // Track view for guests by session ID
                    $sessionId = session()->getId();

                    // Check if this session hasn't viewed this announcement yet
                    if(!$announcementModel->hasBeenViewedBySession($sessionId)) {
                        // Record the view with session_id
                        \DB::table('announcement_views')->insert([
                            'announcement_id' => $announcementModel->id,
                            'user_id' => null,
                            'session_id' => $sessionId,
                            'viewed_at' => now(),
                        ]);
                        $viewRecorded = true;
                    }
                }

                // Update the total view count if a new view was recorded
                if($viewRecorded) {
                    $announcementModel->increment('views');
                }
            }

            $customer = User::where('id', '=', $announcement->customer_id)->first();

            // Check if the author is currently online
            $online_status = DB::table('sessions')
                ->whereNotNull('user_id')
                ->where('user_id', '=', $announcement->customer_id)
                ->exists();

            return view('announcements.view',[
                'announcement' => $announcement,
                'customer'     => $customer,
                'online_status' => $online_status,
            ]);
        } else {
            return view('announcements.index');
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Announcements $announcements)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Announcements $announcements)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Announcements $announcements)
    {
        //
    }
}
