<?php

namespace App\Livewire\Announcements\Categories;

use App\Models\{Announcements};

use Illuminate\Http\Request;
use Illuminate\Support\{Str,Carbon};
use Illuminate\Support\Facades\Auth;

use Livewire\Attributes\Rule;

use Filament\Notifications\Notification;

use Livewire\Component;

class DisplayAll extends Component
{
    public function render()
    {
        if(!Auth::guest() && Auth::user()->hasAnyRole('superadmin', 'admin', 'employee'))
        {
            $announcements = Announcements::leftJoin('users', 'announcements.author_id', '=', 'users.id')
            ->leftJoin('categories', 'announcements.parent_category', '=', 'categories.id')
            ->select('announcements.*', 'categories.*', 'users.*')
            ->selectRaw('users.company as company_name, users.name as customer_name, announcements.id as announcement_id, categories.id as category_id, announcements.created_at as announcement_created')
            ->orderBy('announcement_id', 'DESC')
            ->get();
        } else {
            $announcements = Announcements::leftJoin('users', 'announcements.author_id', '=', 'users.id')
            ->leftJoin('categories', 'announcements.parent_category', '=', 'categories.id')
            ->select('announcements.*', 'categories.*', 'users.*')
            ->selectRaw('users.company as company_name, users.name as customer_name, announcements.id as announcement_id, categories.id as category_id, announcements.created_at as announcement_created')
            ->orderBy('announcement_id', 'DESC')
            ->where('announcements.draft', '!=', '1')->get();
        }
        return view('livewire.announcements.categories.display-all',[
            'announcements' => $announcements,
        ]);
    }
}
