<?php

namespace App\Livewire\Announcements;

use App\Models\Announcements;
use Illuminate\Support\Facades\{Auth, DB};
use Livewire\Component;

class LikeButton extends Component
{
    public $announcementId;
    public $isLiked = false;
    public $likeCount = 0;

    public function mount($announcementId)
    {
        $this->announcementId = $announcementId;
        $this->checkIfLiked();
        $this->updateLikeCount();
    }

    public function toggleLike()
    {
        // Only allow authenticated users to like
        if (Auth::guest()) {
            return;
        }

        $announcement = Announcements::find($this->announcementId);

        if (!$announcement) {
            return;
        }

        $userId = Auth::id();

        if ($announcement->hasBeenLikedByUser($userId)) {
            // Unlike
            DB::table('announcement_likes')
                ->where('announcement_id', $this->announcementId)
                ->where('user_id', $userId)
                ->delete();

            $announcement->decrement('likes');
            $this->isLiked = false;
        } else {
            // Like
            DB::table('announcement_likes')->insert([
                'announcement_id' => $this->announcementId,
                'user_id' => $userId,
                'liked_at' => now(),
            ]);

            $announcement->increment('likes');
            $this->isLiked = true;
        }

        $this->updateLikeCount();
    }

    private function checkIfLiked()
    {
        // Only check for authenticated users
        if (Auth::guest()) {
            $this->isLiked = false;
            return;
        }

        $announcement = Announcements::find($this->announcementId);

        if (!$announcement) {
            return;
        }

        $this->isLiked = $announcement->hasBeenLikedByUser(Auth::id());
    }

    private function updateLikeCount()
    {
        $announcement = Announcements::find($this->announcementId);
        $this->likeCount = $announcement ? $announcement->likes : 0;
    }

    public function render()
    {
        return view('livewire.announcements.like-button');
    }
}
