<?php

namespace App\Livewire\Partials\Announcements\Categories;

use App\Models\{Categories};

use Illuminate\Http\Request;
use Illuminate\Support\{Str,Carbon};
use Illuminate\Support\Facades\Auth;

use Livewire\Attributes\Rule;

use Filament\Notifications\Notification;

use Livewire\Component;

class Edit extends Component
{
    #[Rule('string', message: "Please enter a name for the Category.")]
    public $category_name = '';

    public $uri = '';

    #[Rule('numeric', message: "Please select Displayed or Disabled.")]
    public $display = '';

    public $category_id = '';

    public function mount($category)
    {
        $this->category_name = $category['category_name'];
        $this->uri = $category['uri'];
        $this->display = $category['display'];
        $this->category_id = $category['id'];
    }

    public function update(Request $request)
    {
        if($this->uri)
        {
            $uri = Str::of($this->uri)->slug('-');
        } else {
            $uri = Str::of($this->category_name)->slug('-');
        }
        
        Categories::where('id', '=', $this->category_id)->update([
            'category_name' => $this->category_name,
            'uri' => $uri,
            'display' => $this->display,
        ]);

        Notification::make()
            ->title('Update successfully')
            ->success()
            ->body('The Announcement category has been updated.')
            ->color('success') 
            ->send();

        $this->redirect('/announcements');
    }

    public function render()
    {
        return view('livewire.partials.announcements.categories.edit');
    }
}
