<?php

namespace App\Livewire\Partials\Dashboard;

use App\Models\{User,Tickets};
#use App\Http\Controllers\{TicketsController};

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\{DB, Auth};
use Illuminate\Http\RedirectResponse;

use Livewire\Component;

class Homepage extends Component
{
    public function render()
    {
        $tickets = Tickets::select('users.*', 'tickets.*')->leftjoin('users', 'users.id', 'tickets.user_id')->selectRaw('tickets.id as ticket_id, users.id as customer_id, tickets.created_at as ticket_created')->orderBy('ticket_id', 'desc')->take('7')->get();
        $tickets_count = Tickets::select('users.*', 'tickets.*')->leftjoin('users', 'users.id', 'tickets.user_id')->selectRaw('tickets.id as ticket_id, users.id as customer_id, tickets.created_at as ticket_created')->orderBy('ticket_id', 'desc')->take('7')->count();
        
        $priorities = Tickets::select('users.*', 'tickets.*')->leftjoin('users', 'users.id', 'tickets.user_id')->where('priority', '=', 'high')->orWhere('priority', '=', 'emergency')->selectRaw('tickets.id as ticket_id, users.id as customer_id, tickets.created_at as ticket_created')->orderBy('ticket_id', 'desc')->take('7')->get();
        $priorities_count = Tickets::select('users.*', 'tickets.*')->leftjoin('users', 'users.id', 'tickets.user_id')->where('priority', '=', 'high')->orWhere('priority', '=', 'emergency')->selectRaw('tickets.id as ticket_id, users.id as customer_id, tickets.created_at as ticket_created')->orderBy('ticket_id', 'desc')->take('7')->count();
        
        return view('livewire.partials.dashboard.homepage',[
            'tickets' => $tickets,
            'priorities' => $priorities,
            'tickets_count' => $tickets_count,
            'priorities_count' => $priorities_count,
        ]);
    }
}
