<?php

    namespace App\Livewire\Partials\Tickets;

    use App\Http\Controllers\{TicketsController};
    use App\Models\{User,Departments,Tickets};

    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\{Str,Carbon};

    use Livewire\Attributes\{Rule, Validate};
    use Livewire\Component;

    use Filament\Notifications\Notification;

class ChangeStatus extends Component
{
    #[Validate('required')]
    public $status_name = '';

    public $ticket_id;

    public function mount($ticket_id)
    {
        $this->ticket_id = $ticket_id;
    }

    public function change()
    {
        if($this->status_name != 'closed')
        {
            Tickets::where('id', '=', $this->ticket_id)->update([
                'status' => $this->status_name,
                'date_closed' => '',
            ]);
        } else{
            Tickets::where('id', '=', $this->ticket_id)->update([
                'status' => $this->status_name,
                'date_closed' => Carbon::now(),
            ]);
        }
            
        Notification::make()
            ->title("Ticket updated successfully")
            ->success()
            ->body("The ticket's status has been updated.")
            ->color('success')
            ->send();

        // Dispatch event to update sidebar counts
        $this->dispatch('ticket-updated')->to('sidebar-navigation');
        $this->dispatch('ticket-updated')->to('sidebar-assigned-tickets');

        $this->redirect('/tickets/show/'.$this->ticket_id);
    }

    public function render()
    {
        return view('livewire.partials.tickets.change-status');
    }
}
