<?php

namespace App\Livewire\Partials\Tickets;

use App\Http\Controllers\{TicketsController};
use App\Models\{User,Departments,Tickets};

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\{Str,Carbon};

use Livewire\Attributes\{Rule, Validate};
use Livewire\Component;

use Filament\Notifications\Notification;

class Search extends Component
{
    #[Validate('required')]
    public $email = '';
    #[Validate('required')]
    public $public_hash = '';

    public function search()
    {
        $this->validate();
    
        $check_ticket = Tickets::where('public_email', '=', $this->email)->where('public_hash', '=', $this->public_hash)->lazy();
        if($check_ticket == null)
        {
            $user = User::where('email', '=', $this->email)->lazy();
            if($user)
            {
                $ticket = Tickets::where('user_id', '=', $user->id)->where('public_hash', '=', $this->public_hash)->first();
                if($ticket)
                {
                    $this->redirect("/tickets/public/". $ticket->id . "/" . $ticket->public_hash);
                } else {
                    return redirect()->route('dashboard')->with([
                        'message' => __('Ticket not found'),
                        'type' => 'error',
                    ]);
                }
            } else {
                return redirect()->route('view_tickets');
            }
        } else {
            if($check_ticket != null)
            {
                $ticket = Tickets::where('public_email', '=', $this->email)->where('public_hash', '=', $this->public_hash)->first();
                $this->redirect("/tickets/public/". $ticket->id . "/" . $ticket->public_hash);
            } else {
                return redirect()->route('dashboard')->with([
                    'message' => __('Ticket not found'),
                    'type' => 'error',
                ]);
            }
        }
    }

    public function render()
    {
        return view('livewire.partials.tickets.search');
    }
}
