<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;

class SessionManager extends Component
{
    public $showWarning = false;
    public $timeRemaining = 0;
    
    protected $listeners = ['checkSession'];
    
    public function mount()
    {
        // Get session lifetime in minutes from config
        $this->timeRemaining = config('session.lifetime') * 60; // Convert to seconds
    }
    
    public function checkSession()
    {
        if (!Auth::check()) {
            // Session has expired
            return redirect()->route('login')
                ->with('error', 'Your session has expired. Please login again.');
        }
        
        // Calculate remaining time
        $lastActivity = session('last_activity', time());
        $sessionLifetime = config('session.lifetime') * 60;
        $elapsed = time() - $lastActivity;
        $this->timeRemaining = max(0, $sessionLifetime - $elapsed);
        
        // Show warning when 5 minutes remain
        if ($this->timeRemaining <= 300 && $this->timeRemaining > 0) {
            $this->showWarning = true;
        }
        
        // Session expired
        if ($this->timeRemaining <= 0) {
            Auth::logout();
            return redirect()->route('login')
                ->with('error', 'Your session has expired. Please login again.');
        }
    }
    
    public function extendSession()
    {
        // Update last activity time
        session(['last_activity' => time()]);
        
        // Reset the timer
        $this->timeRemaining = config('session.lifetime') * 60;
        $this->showWarning = false;
        
        // Touch the session to extend it
        session()->regenerate();
        
        $this->dispatch('sessionExtended');
    }
    
    public function render()
    {
        return view('livewire.session-manager');
    }
}