<?php

namespace App\Providers;

use App\Extensions\ExtensionManager;
use Illuminate\Support\ServiceProvider;

class ExtensionServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register the ExtensionManager as a singleton
        $this->app->singleton(ExtensionManager::class, function ($app) {
            return new ExtensionManager();
        });

        // Register the 'extensions' alias
        $this->app->alias(ExtensionManager::class, 'extensions');
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Only discover and register extensions if extensions table exists
        try {
            $extensionManager = $this->app->make(ExtensionManager::class);

            // Discover all available extensions
            $extensionManager->discover();

            if ($this->app->runningInConsole() && !$this->app->runningUnitTests()) {
                // Ensure migrations from all extensions are available to Artisan
                $extensionManager->registerAllMigrations();
            }

            // Register enabled extensions (routes, views, migrations)
            $extensionManager->registerEnabled();
        } catch (\Exception $e) {
            // Silently fail during installation/migration process
            // Log the error if logging is available
            if (config('app.debug')) {
                logger()->warning("Extension system not ready: {$e->getMessage()}");
            }
        }
    }
}
