<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Extension System Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains the configuration options for Ticaga's extension
    | system. Extensions allow you to add custom functionality to Ticaga
    | without modifying the core codebase.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Extensions Path
    |--------------------------------------------------------------------------
    |
    | The directory where installed extensions are stored. By default, this
    | is app/Extensions/Installed. Extensions should be placed in their own
    | subdirectory within this path.
    |
    */

    'path' => app_path('Extensions/Installed'),

    /*
    |--------------------------------------------------------------------------
    | Auto-Discovery
    |--------------------------------------------------------------------------
    |
    | When enabled, the extension system will automatically discover and
    | register extensions found in the extensions path. Disable this if
    | you want to manually control which extensions are loaded.
    |
    */

    'auto_discovery' => env('EXTENSIONS_AUTO_DISCOVERY', true),

    /*
    |--------------------------------------------------------------------------
    | Auto-Register
    |--------------------------------------------------------------------------
    |
    | When enabled, the extension system will automatically register routes,
    | views, and migrations for all enabled extensions. Disable this if you
    | want more control over extension registration.
    |
    */

    'auto_register' => env('EXTENSIONS_AUTO_REGISTER', true),

    /*
    |--------------------------------------------------------------------------
    | Sandbox Mode
    |--------------------------------------------------------------------------
    |
    | When enabled, extensions run in a sandboxed environment with limited
    | access to system resources. This is recommended for third-party
    | extensions. Disable for trusted, first-party extensions only.
    |
    */

    'sandbox_mode' => env('EXTENSIONS_SANDBOX_MODE', false),

    /*
    |--------------------------------------------------------------------------
    | Cache Extensions
    |--------------------------------------------------------------------------
    |
    | When enabled, the list of discovered extensions will be cached for
    | better performance. Clear the cache after installing, updating, or
    | removing extensions.
    |
    */

    'cache_enabled' => env('EXTENSIONS_CACHE_ENABLED', false),

    /*
    |--------------------------------------------------------------------------
    | Cache Key
    |--------------------------------------------------------------------------
    |
    | The cache key used to store the extensions list. You can customize
    | this if it conflicts with other cache keys in your application.
    |
    */

    'cache_key' => 'ticaga.extensions.discovered',

    /*
    |--------------------------------------------------------------------------
    | Cache Duration
    |--------------------------------------------------------------------------
    |
    | How long (in seconds) to cache the extensions list. Default is 1 hour.
    | Set to 0 to cache indefinitely (until manually cleared).
    |
    */

    'cache_duration' => env('EXTENSIONS_CACHE_DURATION', 3600),

    /*
    |--------------------------------------------------------------------------
    | Allowed Capabilities
    |--------------------------------------------------------------------------
    |
    | Define which capabilities extensions are allowed to use. This provides
    | an additional layer of security by limiting what extensions can do.
    | Set to null to allow all capabilities.
    |
    */

    'allowed_capabilities' => null, // or ['import', 'export', 'api', 'webhooks']

    /*
    |--------------------------------------------------------------------------
    | Required Permissions
    |--------------------------------------------------------------------------
    |
    | The permission(s) required to manage extensions. Users must have at
    | least one of these permissions to install, enable, disable, or
    | configure extensions.
    |
    */

    'required_permissions' => ['superadmin'],

    /*
    |--------------------------------------------------------------------------
    | Logging
    |--------------------------------------------------------------------------
    |
    | Enable detailed logging for extension operations. Useful for debugging
    | extension issues or auditing extension activity.
    |
    */

    'logging' => [
        'enabled' => env('EXTENSIONS_LOGGING', true),
        'channel' => env('EXTENSIONS_LOG_CHANNEL', 'stack'),
        'level' => env('EXTENSIONS_LOG_LEVEL', 'info'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Marketplace (Future)
    |--------------------------------------------------------------------------
    |
    | Configuration for the extension marketplace. This is reserved for
    | future use when a marketplace is implemented.
    |
    */

    'marketplace' => [
        'enabled' => false,
        'url' => env('EXTENSIONS_MARKETPLACE_URL', null),
        'api_key' => env('EXTENSIONS_MARKETPLACE_API_KEY', null),
    ],
];
