<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Set a database-level default for the account_manager column.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('users', 'account_manager')) {
            return;
        }

        DB::statement("ALTER TABLE users ALTER COLUMN account_manager SET DEFAULT '0'");
    }

    /**
     * Revert the database-level default.
     */
    public function down(): void
    {
        if (!Schema::hasColumn('users', 'account_manager')) {
            return;
        }

        DB::statement('ALTER TABLE users ALTER COLUMN account_manager DROP DEFAULT');
    }
};
