<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('departments', function (Blueprint $table) {
            $table->id();
            $table->string('department_name');
            $table->string('department_description')->nullable();
            $table->string('slug');
            $table->integer('allows_high_priority')->default('0');
            $table->integer('is_public')->default('1');
            $table->integer('is_disabled')->default('0');
            $table->string('department_email')->nullable();
            $table->integer('soft_deleted')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('departments');
    }
};
