<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string'); // string, boolean, json, etc.
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Insert default license key from .env if it exists
        $licenseKey = config('ticaga.key');
        if ($licenseKey && !empty($licenseKey)) {
            DB::table('settings')->insert([
                'key' => 'license_key',
                'value' => $licenseKey,
                'type' => 'string',
                'description' => 'Ticaga License Key',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
