<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('departments', function (Blueprint $table) {
            // Attachment settings (null = use global settings)
            $table->boolean('attachments_enabled')->nullable()->after('department_email');
            $table->unsignedInteger('max_file_size_mb')->nullable()->after('attachments_enabled');
            $table->unsignedInteger('max_files_per_ticket')->nullable()->after('max_file_size_mb');
            $table->json('allowed_file_types')->nullable()->after('max_files_per_ticket'); // Whitelist
            $table->json('blocked_file_types')->nullable()->after('allowed_file_types'); // Blacklist
            $table->unsignedBigInteger('storage_quota_mb')->nullable()->after('blocked_file_types'); // Per-department quota
            $table->boolean('require_virus_scan')->nullable()->after('storage_quota_mb');
            $table->boolean('enable_thumbnails')->nullable()->after('require_virus_scan');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('departments', function (Blueprint $table) {
            $table->dropColumn([
                'attachments_enabled',
                'max_file_size_mb',
                'max_files_per_ticket',
                'allowed_file_types',
                'blocked_file_types',
                'storage_quota_mb',
                'require_virus_scan',
                'enable_thumbnails',
            ]);
        });
    }
};
