<?php

use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('logs', function (Blueprint $table) {
            $table->id('log_id');
            $table->string('log_type', 32);
            $table->foreignIdFor(User::class, 'user_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignIdFor(User::class, 'customer_id')->nullable()->constrained()->nullOnDelete();
            $table->text('message');
            $table->ipAddress('ip_address')->nullable();
            $table->boolean('visible')->default(true);
            $table->timestamp('created_at')->useCurrent();

            $table->index('log_type');
            $table->index('visible');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('logs');
    }
};
