<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            // Add parent_id for hierarchical categories (nullable for top-level categories)
            $table->unsignedBigInteger('parent_id')->nullable()->after('id');

            // Add sort_order for custom ordering within the same level
            $table->unsignedInteger('sort_order')->default(0)->after('display');

            // Add foreign key constraint with cascade delete
            $table->foreign('parent_id')
                  ->references('id')
                  ->on('categories')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            // Drop foreign key first
            $table->dropForeign(['parent_id']);

            // Drop columns
            $table->dropColumn(['parent_id', 'sort_order']);
        });
    }
};
