<div class="flex w-full flex-1 flex-col gap-6 rounded-2xl">
    <div class="grid auto-rows-min gap-6 md:grid-cols-3">
        <a href="{{ route('departments') }}"
           class="flex flex-col items-center justify-center gap-3 rounded-xl border border-gray-200 bg-white p-8 text-center shadow-sm transition hover:-translate-y-0.5 hover:shadow-md dark:border-gray-700 dark:bg-gray-900">
            <x-mary-icon name="lucide.layout-list" class="h-10 w-10 text-indigo-500 dark:text-indigo-300" />
            <p class="text-base font-medium text-gray-900 dark:text-white">{{ __('View our departments') }}</p>
        </a>
        <a href="{{ route('view_tickets') }}"
           class="flex flex-col items-center justify-center gap-3 rounded-xl border border-gray-200 bg-white p-8 text-center shadow-sm transition hover:-translate-y-0.5 hover:shadow-md dark:border-gray-700 dark:bg-gray-900">
            <x-mary-icon name="lucide.message-circle-more" class="h-10 w-10 text-indigo-500 dark:text-indigo-300" />
            <p class="text-base font-medium text-gray-900 dark:text-white">{{ __('View my tickets') }}</p>
        </a>
        <a href="{{ route('view_announcements') }}"
           class="flex flex-col items-center justify-center gap-3 rounded-xl border border-gray-200 bg-white p-8 text-center shadow-sm transition hover:-translate-y-0.5 hover:shadow-md dark:border-gray-700 dark:bg-gray-900">
            <x-mary-icon name="lucide.newspaper" class="h-10 w-10 text-indigo-500 dark:text-indigo-300" />
            <p class="text-base font-medium text-gray-900 dark:text-white">{{ __('Find out the latest news') }}</p>
        </a>
    </div>
    <div class="w-full -mt-2">
        <livewire:clients.ticket_widget :client_id="Auth::user()->id" />
    </div>
</div>
