<x-layouts.app.sidebar :title="$title ?? null">
    <flux:main class="!p-0">
        <!-- Professional Top Navigation Bar (Sticky on Desktop) -->
        @auth
            @if(auth()->user()->hasAnyRole('superadmin','admin'))
                <nav class="lg:sticky lg:top-0 z-30 bg-white dark:bg-zinc-900 border-b border-zinc-200 dark:border-zinc-700 mb-3">
                    <div class="px-4 py-3">
                        <div class="flex items-center">
                            <!-- Administration Dropdown on Left -->
                            <flux:dropdown position="bottom" align="start">
                                <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white" size="sm" icon-trailing="chevron-down">
                                    <span class="flex items-center gap-2">
                                        <flux:icon.shield-check variant="outline" class="w-4 h-4" />
                                        {{ __('Administration') }}
                                    </span>
                                </flux:button>

                                <flux:menu class="w-[220px]">
                                    <flux:menu.item icon="heart-pulse" :href="route('system.health')" wire:navigate>
                                        {{ __('System Health') }}
                                    </flux:menu.item>
                                    @if(auth()->user()->hasRole('superadmin'))
                                        <flux:menu.item icon="puzzle-piece" :href="route('extensions')" wire:navigate>
                                            {{ __('Extensions') }}
                                        </flux:menu.item>

                                        @if(app('extensions')->isEnabled('importer'))
                                            <flux:menu.item icon="arrow-down-tray" :href="route('extensions.importer.index')" wire:navigate>
                                                {{ __('Importer') }}
                                            </flux:menu.item>
                                        @endif
                                    @endif

                                    {{-- Knowledge Base Admin (if extension is enabled) --}}
                                    @if(app('extensions')->isEnabled('knowledgebase') && Route::has('help.admin.analytics'))
                                        <flux:menu.item icon="book-open" :href="route('help.admin.analytics')" wire:navigate>
                                            {{ __('Knowledgebase') }}
                                        </flux:menu.item>
                                    @endif

                                    {{-- SLA Tracking Admin (if extension is enabled) --}}
                                    @if(app('extensions')->isEnabled('sla-tracking') && Route::has('sla-tracking.dashboard'))
                                        <flux:menu.item icon="clock" :href="route('sla-tracking.dashboard')" wire:navigate>
                                            {{ __('SLA Tracking') }}
                                        </flux:menu.item>
                                    @endif
                                    {{-- GDPR Compliance Admin (if extension is enabled) --}}
                                    @if(app('extensions')->isEnabled('gdpr-compliance') && Route::has('admin.gdpr.dashboard'))
                                        <flux:menu.item icon="shield-check" :href="route('admin.gdpr.dashboard')" wire:navigate>
                                            {{ __('GDPR Compliance') }}
                                        </flux:menu.item>
                                    @endif
                                    {{-- Live Chat Admin (if extension is enabled) --}}
                                    @if(app('extensions')->isEnabled('live-chat') && Route::has('live-chat.settings'))
                                        <flux:menu.item icon="cog-6-tooth" :href="route('live-chat.settings')" wire:navigate>
                                            {{ __('Live Chat') }}
                                        </flux:menu.item>
                                    @endif
                                </flux:menu>
                            </flux:dropdown>
                        </div>
                    </div>
                </nav>
            @endif
        @endauth

        {{-- SLA Tracking Navigation (conditionally shown on SLA pages) --}}
        @auth
            @if(app('extensions')->isEnabled('sla-tracking') && request()->routeIs('sla-tracking.*'))
                @include('extension.sla-tracking::partials.admin-nav')
            @endif
        @endauth

        {{-- GDPR Compliance Navigation (conditionally shown on GDPR pages) --}}
        @auth
            @if(request()->routeIs('admin.gdpr.*'))
                @include('gdpr::partials.navigation')
            @endif
        @endauth

        @if($noPadding ?? false)
            {{ $slot }}
        @else
            <div class="p-4 sm:p-6">
                {{ $slot }}
            </div>
        @endif
    </flux:main>
    @auth
        @if(app('extensions')->isEnabled('live-chat') && auth()->user()->hasAnyRole('superadmin','admin','employee'))
            @livewire('live-chat.agent-dock')
        @endif
    @endauth
    <script>
        window.addEventListener('DOMContentLoaded', function () {
            window.Echo.channel('system-maintenance')
                .listen('SystemMaintenanceEvent', (event) => {
                    console.log(event)
                });
        });
    </script>
</x-layouts.app.sidebar>
