<div wire:poll.visible>
    <div class="flex rounded-xl">
        @if(count($announcements) > '0')
            <div class="grid gap-4 md:grid-cols-2 w-full">
                @foreach($announcements as $announcement)
                    <a href="{{ route('show_announcement',[ $announcement->id, $announcement->slug]) }}">
                        <div class="bg-white border border-neutral-200 rounded-lg shadow-sm p-5 dark:text-white dark:bg-gray-900 dark:border-neutral-700">
                            <div class="flex">
                                <div class="w-10 flex-none">
                                    <div class="flex items-start justify-center">
                                        <div class="flex flex-col w-10 relative">
                                            <span class="bg-primary text-center text-white p-1 rounded-t-md">{{ Carbon\Carbon::parse($announcement->announcement_created)->format('M') }}</span>
                                            <span class="bg-zinc-50 text-2xl text-primary font-bold bg-white text-center px-1.3 rounded-b-md border-zinc-200">{{ Carbon\Carbon::parse($announcement->announcement_created)->format('d') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="ml-3 mt-3">
                                    <flux:heading size="lg">{{ $announcement->title }}</flux:heading>
                                    <flux:text class="text-xs">Posted by {{ $announcement->customer_name }} on {{ Carbon\Carbon::parse($announcement->announcement_created)->format('d F Y') }}</flux:text>
                                </div>
                            </div>
                            <flux:text class="mt-2 whitespace-pre-line">
                                {!! Str::of($announcement->content)->inlinemarkdown(['html_input' => 'strip', 'allow_unsafe_links' => false,])->limit(260, preserveWords: true) !!}
                            </flux:text>
                            <flux:text class="mt-2">
                                Click to read more &raquo;
                            </flux:text>
                        </div>
                    </a>
                @endforeach
            </div>
        @else
            <div class="p-4 text-sm text-blue-800 bg-blue-50 border border-blue-300 rounded-lg dark:shadow-sm dark:bg-gray-900 dark:text-white dark:border-neutral-700 w-full" role="alert">
                {{ __("Currently there are no announcements.") }}
            </div>
        @endif
    </div>
</div>

