<div>
    <div class="container mx-auto px-8 pb-8">
        <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Create SLA Policy</h1>
        <p class="text-gray-600 dark:text-gray-400">Define response and resolution time targets for your support tickets</p>
    </div>

        <form wire:submit.prevent="save" class="space-y-6">
            <!-- Name -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700">Policy Name</label>
                <input
                    type="text"
                    id="name"
                    wire:model="name"
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                    required
                >
                @error('name') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
            </div>

            <!-- Description -->
            <div>
                <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                <textarea
                    id="description"
                    wire:model="description"
                    rows="3"
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                ></textarea>
                @error('description') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
            </div>

            <!-- Response Time -->
            <div>
                <label for="response_time" class="block text-sm font-medium text-gray-700">Response Time (minutes)</label>
                <input
                    type="number"
                    id="response_time"
                    wire:model="response_time"
                    min="0"
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                >
                @error('response_time') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
            </div>

            <!-- Resolution Time -->
            <div>
                <label for="resolution_time" class="block text-sm font-medium text-gray-700">Resolution Time (minutes)</label>
                <input
                    type="number"
                    id="resolution_time"
                    wire:model="resolution_time"
                    min="0"
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                >
                @error('resolution_time') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
            </div>

            <!-- Active -->
            <div class="flex items-center">
                <input
                    type="checkbox"
                    id="active"
                    wire:model="active"
                    class="h-4 w-4 rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                >
                <label for="active" class="ml-2 block text-sm text-gray-900">Active</label>
            </div>

            <!-- Departments -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Departments</label>
                @if($departments && count($departments) > 0)
                    <div class="space-y-2">
                        @foreach($departments as $department)
                            <div class="flex items-center">
                                <input
                                    type="checkbox"
                                    id="dept_{{ $department->id }}"
                                    wire:model="selected_departments"
                                    value="{{ $department->id }}"
                                    class="h-4 w-4 rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                                >
                                <label for="dept_{{ $department->id }}" class="ml-2 block text-sm text-gray-900">
                                    {{ $department->department_name }}
                                </label>
                            </div>
                        @endforeach
                    </div>
                @else
                    <p class="text-sm text-gray-500">No departments available</p>
                @endif
                @error('selected_departments') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
            </div>

            <!-- Submit -->
            <div class="flex items-center justify-end space-x-4">
                <a href="{{ route('sla-tracking.policies.index') }}" class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50">
                    Cancel
                </a>
                <button
                    type="submit"
                    class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500"
                >
                    Create Policy
                </button>
            </div>
        </form>
        </div>
    </div>
</div>