<div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6 mb-4">
    @if(!$ticket || !$ticket->sla_policy_id)
        <div class="text-center py-4">
            <p class="text-sm text-gray-500 dark:text-gray-400">No SLA policy assigned to this ticket</p>
        </div>
    @elseif($isExempt)
        <div class="flex items-start gap-3">
            <div class="flex-shrink-0">
                <svg class="w-6 h-6 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"/>
                </svg>
            </div>
            <div class="flex-1">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">SLA Exempt</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">
                    This ticket is exempt from SLA tracking.
                </p>
                @if($exemptionReason)
                <p class="mt-2 text-xs text-gray-500 dark:text-gray-400 italic">
                    Reason: {{ $exemptionReason }}
                </p>
                @endif
            </div>
        </div>
    @else
        <!-- SLA Header -->
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">SLA Tracking</h3>
            <span class="px-3 py-1 text-xs font-medium rounded-full
                @if($slaStatus === 'on_track') bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200
                @elseif($slaStatus === 'at_risk') bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200
                @elseif($slaStatus === 'breached') bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200
                @elseif($slaStatus === 'paused') bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200
                @else bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200
                @endif">
                {{ ucfirst(str_replace('_', ' ', $slaStatus)) }}
            </span>
        </div>

        <!-- SLA Policy Info -->
        <div class="mb-4 text-sm text-gray-600 dark:text-gray-400">
            <span class="font-medium text-gray-900 dark:text-white">Policy:</span> {{ $slaPolicy->name }}
        </div>

        @if($isPaused)
        <!-- Paused Notice -->
        <div class="mb-4 p-3 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
            <div class="flex items-center gap-2">
                <svg class="w-5 h-5 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 9v6m4-6v6m7-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <div class="flex-1">
                    <p class="text-sm font-medium text-blue-900 dark:text-blue-200">SLA Timer Paused</p>
                    <p class="text-xs text-blue-700 dark:text-blue-300">Paused for: {{ floor($pauseDuration / 60) }}h {{ $pauseDuration % 60 }}m</p>
                </div>
            </div>
        </div>
        @endif

        <!-- First Response SLA -->
        @if($firstResponseDue && !$ticket->sla_first_response_breached)
        <div class="mb-5">
            <div class="flex items-center justify-between mb-2">
                <span class="text-sm font-medium text-gray-700 dark:text-gray-300">First Response</span>
                <span class="text-xs text-gray-500 dark:text-gray-400">
                    Due: {{ \Carbon\Carbon::parse($firstResponseDue)->format('M d, Y H:i') }}
                </span>
            </div>
            <div class="relative pt-1">
                <div class="overflow-hidden h-3 text-xs flex rounded-full bg-gray-200 dark:bg-gray-700">
                    <div style="width:{{ $firstResponseProgress }}%"
                         class="shadow-none flex flex-col text-center whitespace-nowrap text-white justify-center transition-all duration-500
                         @if($firstResponseProgress < 70) bg-green-500
                         @elseif($firstResponseProgress < 90) bg-yellow-500
                         @else bg-red-500
                         @endif">
                    </div>
                </div>
            </div>
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                {{ round($firstResponseProgress) }}% elapsed
                @if($firstResponseDue)
                    • {{ \Carbon\Carbon::parse($firstResponseDue)->diffForHumans() }}
                @endif
            </p>
        </div>
        @elseif($ticket->sla_first_response_breached)
        <div class="mb-5 p-3 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg">
            <div class="flex items-center gap-2">
                <svg class="w-5 h-5 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <p class="text-sm font-medium text-red-900 dark:text-red-200">First Response SLA Breached</p>
            </div>
        </div>
        @endif

        <!-- Resolution SLA -->
        @if($resolutionDue && !$ticket->sla_resolution_breached)
        <div class="mb-5">
            <div class="flex items-center justify-between mb-2">
                <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Resolution</span>
                <span class="text-xs text-gray-500 dark:text-gray-400">
                    Due: {{ \Carbon\Carbon::parse($resolutionDue)->format('M d, Y H:i') }}
                </span>
            </div>
            <div class="relative pt-1">
                <div class="overflow-hidden h-3 text-xs flex rounded-full bg-gray-200 dark:bg-gray-700">
                    <div style="width:{{ $resolutionProgress }}%"
                         class="shadow-none flex flex-col text-center whitespace-nowrap text-white justify-center transition-all duration-500
                         @if($resolutionProgress < 70) bg-green-500
                         @elseif($resolutionProgress < 90) bg-yellow-500
                         @else bg-red-500
                         @endif">
                    </div>
                </div>
            </div>
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                {{ round($resolutionProgress) }}% elapsed
                @if($resolutionDue)
                    • {{ \Carbon\Carbon::parse($resolutionDue)->diffForHumans() }}
                @endif
            </p>
        </div>
        @elseif($ticket->sla_resolution_breached)
        <div class="mb-5 p-3 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg">
            <div class="flex items-center gap-2">
                <svg class="w-5 h-5 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <p class="text-sm font-medium text-red-900 dark:text-red-200">Resolution SLA Breached</p>
            </div>
        </div>
        @endif

        <!-- Action Buttons -->
        @hasanyrole('employee|admin|superadmin')
        <div class="flex gap-2 mt-4 pt-4 border-t border-gray-200 dark:border-gray-700">
            @if($isPaused)
                <button wire:click="resumeSla" wire:loading.attr="disabled"
                    class="flex-1 px-4 py-2 bg-green-600 hover:bg-green-700 text-white text-sm font-medium rounded-md transition disabled:opacity-50">
                    <span wire:loading.remove>Resume SLA</span>
                    <span wire:loading>Resuming...</span>
                </button>
            @else
                <button wire:click="$set('showPauseModal', true)"
                    class="flex-1 px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-md transition">
                    Pause SLA
                </button>
            @endif

            @hasanyrole('admin|superadmin')
            <button wire:click="$set('showExemptModal', true)"
                class="flex-1 px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white text-sm font-medium rounded-md transition">
                Mark Exempt
            </button>
            @endhasanyrole
        </div>
        @endhasanyrole
    @endif

    <!-- Pause Modal -->
    @if($showPauseModal)
    <div class="fixed inset-0 z-50 overflow-y-auto" style="display: block;">
        <div class="flex items-center justify-center min-h-screen px-4">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" wire:click="$set('showPauseModal', false)"></div>
            <div class="relative bg-white dark:bg-gray-800 rounded-lg max-w-lg w-full p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Pause SLA Timer</h3>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Reason for pausing <span class="text-red-500">*</span>
                    </label>
                    <textarea wire:model="pauseReason" rows="3"
                        class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white focus:ring-2 focus:ring-indigo-500"
                        placeholder="e.g., Awaiting customer response, Escalated to third-party..."></textarea>
                    @error('pauseReason') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                </div>
                <div class="flex gap-2">
                    <button wire:click="pauseSla" wire:loading.attr="disabled"
                        class="flex-1 px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-md disabled:opacity-50">
                        Confirm Pause
                    </button>
                    <button wire:click="$set('showPauseModal', false)"
                        class="px-4 py-2 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-md">
                        Cancel
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Exempt Modal -->
    @if($showExemptModal)
    <div class="fixed inset-0 z-50 overflow-y-auto" style="display: block;">
        <div class="flex items-center justify-center min-h-screen px-4">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" wire:click="$set('showExemptModal', false)"></div>
            <div class="relative bg-white dark:bg-gray-800 rounded-lg max-w-lg w-full p-6">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Mark Ticket as SLA-Exempt</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    This ticket will no longer be tracked for SLA compliance. This action cannot be undone.
                </p>
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Exemption Reason <span class="text-red-500">*</span>
                    </label>
                    <textarea wire:model="exemptReason" rows="3"
                        class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white focus:ring-2 focus:ring-indigo-500"
                        placeholder="e.g., Customer request, Special circumstances..."></textarea>
                    @error('exemptReason') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                </div>
                <div class="flex gap-2">
                    <button wire:click="exemptFromSla" wire:loading.attr="disabled"
                        class="flex-1 px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-md disabled:opacity-50">
                        Confirm Exemption
                    </button>
                    <button wire:click="$set('showExemptModal', false)"
                        class="px-4 py-2 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-md">
                        Cancel
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Auto-refresh every 60 seconds -->
    <script>
        setInterval(() => {
            @this.call('loadTicketData');
        }, 60000);
    </script>
</div>
