<div wire:key="{{ $user->id }}" x-data="{
    copyPassword() {
        const password = @this.password;
        if (!password) {
            alert('Please generate a password first');
            return;
        }

        // Create temporary input for Safari compatibility
        const input = document.createElement('input');
        input.style.position = 'fixed';
        input.style.opacity = '0';
        input.value = password;
        document.body.appendChild(input);
        input.select();
        input.setSelectionRange(0, 99999);

        try {
            document.execCommand('copy');
            console.log('Password copied successfully');
            alert('Password copied to clipboard!');
        } catch (err) {
            console.error('Failed to copy:', err);
            alert('Could not copy to clipboard');
        }

        document.body.removeChild(input);
    }
}">
    <form wire:submit="change">
        <div class="mt-3">
            <flux:input label="Password" type="password" wire:model="password" viewable copyable />
        </div>
        <div class="mt-3">
            <flux:input label="Confirm Password" type="password_confirmation" wire:model="password_confirmation" viewable />
        </div>
        <div class="flex justify-between mt-3">
            <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white" type="button" wire:click="generatePassword">{{ __("Generate Secure Password") }}</flux:button>
            <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white" type="submit">{{ __("Update") }}</flux:button>
        </div>
    </form>
</div>