<div>
    <form wire:submit="change">
        <div class="col-span-full">
            <label for="status_name" class="block text-sm/6 font-medium text-gray-900 dark:text-white">{{ __('Status') }}</label>
            <div class="mt-2 grid grid-cols-1">
                <select id="status_name" name="status_name" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3 text-base text-gray-900 dark:text-white dark:bg-gray-900 dark:outline-gray-600 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" wire:model.live="status_name">
                    <option class="dark:text-white">Select the new status</option>
                    @foreach (App\Enums\Status::cases() as $case)
                        <option class="block w-full dark:text-white"
                            value="{{ $case->value }}" wire:key="{{ $case->value }}">
                            {{ ucfirst($case->value) }}
                        </option>
                    @endforeach
                </select>
                @error('status_name') <em class="text-black dark:text-white">{{ $message }}</em>@enderror
            </div>
        </div>
        <flux:button class="!bg-indigo-700 hover:!bg-indigo-500 !text-white mt-3" type="submit">{{ __("Update") }}</flux:button>
    </form>
</div>