<div>
    <form wire:submit.prevent="save">
        <div class="bg-white dark:bg-gray-800">
            @if($content_count > 0)
                <div class="mb-6 bg-blue-50 dark:bg-blue-900 border-l-4 border-blue-400 p-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <div class="ml-3">
                            <div class="text-sm text-blue-700 dark:text-blue-200">
                                This category contains {{ $content_count }} item{{ $content_count !== 1 ? 's' : '' }}. Changing the URL slug will break existing links.
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <div class="space-y-6">
                <!-- Type (read-only) -->
                <div>
                    <flux:label>Category Type</flux:label>
                    <div class="px-3 py-2 bg-gray-100 dark:bg-gray-700 rounded-lg text-sm text-gray-700 dark:text-gray-300">
                        @php
                            $typeValue = $type instanceof \BackedEnum ? $type->value : $type;
                        @endphp
                        {{ $availableTypes[$typeValue] ?? ucfirst($typeValue) }}
                    </div>
                    <flux:description>Category type cannot be changed after creation.</flux:description>
                </div>

                <!-- Name -->
                <div>
                    <flux:label for="category_name" required>Category Name</flux:label>
                    <flux:input wire:model.live="category_name" id="category_name" type="text" required />
                    @error('category_name')
                        <flux:error>{{ $message }}</flux:error>
                    @enderror
                </div>

                <!-- Parent -->
                <div>
                    <flux:label for="parent_id">Parent Category (Optional)</flux:label>
                    <flux:select wire:model="parent_id" id="parent_id">
                        <option value="">None - Top-level category</option>
                        @foreach($availableParents as $parent)
                            <option value="{{ $parent->id }}">
                                @if($parent->parent)
                                    {{ $parent->getBreadcrumbPath(' > ') }}
                                @else
                                    {{ $parent->category_name }}
                                @endif
                            </option>
                        @endforeach
                    </flux:select>
                </div>

                <!-- Sort Order -->
                <div>
                    <flux:label for="sort_order">Sort Order</flux:label>
                    <flux:input wire:model="sort_order" id="sort_order" type="number" min="0" />
                </div>

                <!-- URL Slug -->
                <div>
                    <flux:label for="uri" required>URL Slug</flux:label>
                    <flux:input wire:model.blur="uri" id="uri" type="text" required />
                    @error('uri')
                        <flux:error>{{ $message }}</flux:error>
                    @enderror
                </div>

                <!-- Visibility -->
                <div>
                    <flux:label for="display">Visibility</flux:label>
                    <flux:select wire:model="display" id="display">
                        <option value="1">Visible</option>
                        <option value="0">Hidden</option>
                    </flux:select>
                </div>
            </div>

            <div class="mt-8 flex items-center justify-between border-t border-gray-200 dark:border-gray-700 pt-6">
                <flux:button href="{{ route('settings.categories') }}" variant="ghost">Cancel</flux:button>
                <flux:button type="submit" class="!bg-indigo-700 hover:!bg-indigo-500 !text-white">Save Changes</flux:button>
            </div>
        </div>
    </form>
</div>
