<div id="typing-indicator-{{ $ticket_id }}" class="mb-4" style="display: none;">
    <div class="flex items-center gap-2 p-3 bg-indigo-50 dark:bg-indigo-900/30 rounded-lg border border-indigo-200 dark:border-indigo-600">
        <div class="flex items-center gap-1.5">
            <div class="flex space-x-1">
                <div class="w-2 h-2 bg-indigo-600 dark:bg-indigo-400 rounded-full animate-bounce" style="animation-delay: 0ms;"></div>
                <div class="w-2 h-2 bg-indigo-600 dark:bg-indigo-400 rounded-full animate-bounce" style="animation-delay: 150ms;"></div>
                <div class="w-2 h-2 bg-indigo-600 dark:bg-indigo-400 rounded-full animate-bounce" style="animation-delay: 300ms;"></div>
            </div>
        </div>
        <div id="typing-message-{{ $ticket_id }}" class="text-sm font-medium text-indigo-700 dark:text-indigo-300">
            <!-- Typing message will be inserted here -->
        </div>
        <div id="typing-avatars-{{ $ticket_id }}" class="flex -space-x-2 ml-2">
            <!-- Typing user avatars will be inserted here (employees only) -->
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const ticketId = {{ $ticket_id }};
            const containerEl = document.getElementById('typing-indicator-' + ticketId);
            const messageEl = document.getElementById('typing-message-' + ticketId);
            const avatarsEl = document.getElementById('typing-avatars-' + ticketId);

            // Track who is typing
            let typingUsers = new Map();
            let typingTimeouts = new Map();

            // Check if user is employee
            const isEmployee = {{ Auth::check() && Auth::user()->hasAnyRole('superadmin', 'admin', 'employee') ? 'true' : 'false' }};

            // Check if Echo is available
            if (typeof window.Echo === 'undefined') {
                return;
            }

            // Initialize global channel storage
            window.ticketChannels = window.ticketChannels || {};

            try {
                // Reuse existing channel or create new one
                if (!window.ticketChannels[ticketId]) {
                    window.ticketChannels[ticketId] = window.Echo.join('ticket.' + ticketId);
                }
                const channel = window.ticketChannels[ticketId];

                // Listen for typing events
                channel.listenForWhisper('typing', (e) => {
                    const userId = e.user.id;
                    const currentUserId = {{ Auth::id() ?? 'null' }};

                    // Don't show typing indicator for current user
                    if (userId === currentUserId) {
                        return;
                    }

                    // For private notes, only show to employees
                    if (!e.isPublic && !isEmployee) {
                        return;
                    }

                    // Add user to typing list
                    typingUsers.set(userId, e.user);

                    // Clear existing timeout for this user
                    if (typingTimeouts.has(userId)) {
                        clearTimeout(typingTimeouts.get(userId));
                    }

                    // Set timeout to remove user after 10 seconds of inactivity
                    const timeout = setTimeout(() => {
                        typingUsers.delete(userId);
                        typingTimeouts.delete(userId);
                        updateTypingIndicator();
                    }, 10000);

                    typingTimeouts.set(userId, timeout);
                    updateTypingIndicator();
                });

                // Listen for stopped typing events
                channel.listenForWhisper('stopped-typing', (e) => {
                    const userId = e.user.id;

                    // Clear timeout
                    if (typingTimeouts.has(userId)) {
                        clearTimeout(typingTimeouts.get(userId));
                        typingTimeouts.delete(userId);
                    }

                    // Remove user from typing list
                    typingUsers.delete(userId);
                    updateTypingIndicator();
                });

            } catch (error) {
                // Silently fail
            }

            function updateTypingIndicator() {
                if (typingUsers.size === 0) {
                    containerEl.style.display = 'none';
                    return;
                }

                containerEl.style.display = 'block';

                // Clear existing avatars
                avatarsEl.innerHTML = '';

                if (isEmployee) {
                    // Employees see detailed info with names and avatars
                    const names = Array.from(typingUsers.values()).map(user => user.name);

                    if (names.length === 1) {
                        messageEl.textContent = names[0] + ' is typing a response...';
                    } else if (names.length === 2) {
                        messageEl.textContent = names[0] + ' and ' + names[1] + ' are typing...';
                    } else {
                        messageEl.textContent = names[0] + ' and ' + (names.length - 1) + ' others are typing...';
                    }

                    // Add avatars for employees
                    Array.from(typingUsers.values()).forEach(user => {
                        const avatarDiv = document.createElement('div');
                        avatarDiv.className = 'relative group';
                        avatarDiv.title = user.name;

                        const img = document.createElement('img');
                        img.className = 'w-6 h-6 rounded-full border-2 border-white dark:border-gray-800';

                        if (user.profile_photo_path) {
                            img.src = '{{ config('app.url') }}/storage/' + user.profile_photo_path;
                        } else {
                            const emailHash = user.email_hash || 'default';
                            img.src = 'https://gravatar.com/avatar/' + emailHash + '.png?d=monsterid&s=48';
                        }

                        img.alt = user.name;
                        avatarDiv.appendChild(img);
                        avatarsEl.appendChild(avatarDiv);
                    });

                } else {
                    // Customers see generic message
                    messageEl.textContent = 'An employee is preparing a response...';
                }
            }
        });
    </script>
</div>
