<?php

use Illuminate\Support\Facades\Broadcast;

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return (int) $user->id === (int) $id;
});
Broadcast::channel('system-maintenance', function () {
    // Public Channel
});

// Presence channel for ticket viewers
Broadcast::channel('ticket.{ticketId}', function ($user, $ticketId) {
    // You can add additional authorization logic here
    // For example, check if user has permission to view this ticket
    if ($user) {
        return [
            'id' => $user->id,
            'name' => $user->name,
            'email' => $user->email,
            'email_hash' => hash('sha256', strtolower(trim($user->email))),
            'profile_photo_path' => $user->profile_photo_path,
        ];
    }
});

// Live Chat private channel for chat sessions
// Allows both authenticated employees and guest users with valid session IDs
Broadcast::channel('chat.{sessionId}', function ($user, $sessionId) {
    // If authenticated user (employee), allow access
    if ($user) {
        return true;
    }

    // For guest users, verify the session exists and belongs to them
    // This allows the widget to work for non-authenticated visitors
    $session = \App\Extensions\Installed\LiveChat\Models\ChatSession::find($sessionId);

    if ($session) {
        // Allow access if session is active or waiting
        return in_array($session->status, ['waiting', 'active']);
    }

    return false;
});
